#include <hc11.h>
#define LEDPORT	*(unsigned char volatile *)(0x1404)

volatile unsigned char flag = 0;

#define TICK 30

#define INTERRUPT __attribute__((interrupt))

void INTERRUPT rtiisr(void)
{
	static unsigned char tick = TICK;

	if (--tick == 0)
	{
        tick =  TICK;
		flag++;
	}

	TFLG2 = 0x40;
}



int main(void)
{
    char image = 1;
    PACTL = 0;
	TMSK2 = 0x40;

	asm("cli");

    for(;;)
    {
        while(flag == 0);
        flag--;
        LEDPORT = image;
        image <<= 1;
        if (image == 0)
           image = 1;
    }
    return 0;
}
